
clear all
close all
clc

load("DOPPIA2")

time       =  DOPPIA2.uno.data.time;
P_1        =  DOPPIA2.uno.data.P_1;
P_2        =  DOPPIA2.uno.data.P_2;
Spool_FB   =  DOPPIA2.uno.data.Spool_FB;
Spool_Cmd  =  DOPPIA2.uno.data.Spool_Cmd;
Load       =  DOPPIA2.uno.data.Load;
Delta_P    =  P_2-P_1;

%% Parametri simulink OL

dt=1/1000;
StopTime=time(end);

p_S=280e5;                 %% pressione di alimentazione [Pa]
p_T=1e5;                   %% pressione di scarico [Pa]
P_A0=P_2(1)*10^5;          %% pressione iniziale nelle camere [Pa]  
P_B0=P_1(1)*10^5;          %% pressione iniziale nelle camere [Pa]  
rho=900;                   %% densità olio [kg/m^3]
beta=1.56e9;               %% modulo di bulk [Pa]
mu=0.0273;                 %% viscosità dinamica [Pa*s]

%% Servovalvola

sigma_n=220*2*pi;
K_s=0.0000731;
zeta_n=0.7;


w=0.0249;                             %% luce [m]
eps_1=-3.7e-6;                        %% ricoprimento S-A [m]
eps_2=-3.7e-6;                        %% ricoprimento B-T [m]
eps_3=-3.7e-6;                        %% ricoprimento S-B [m]
eps_4=-3.7e-6;                        %% ricoprimento A-T [m]

C_d1=0.3793;
C_d2=0.3969;
C_d3=0.4703;
C_d4=0.3;

bias=-0.2957;  % bias [m] calcolato da una prova con comando nullo
% 0.2957

%% Attuatore 

d_stantuffo=0.074;                                        %% diametro stantuffo[m]
d_stelo=0.05;                                             %% diametro stelo [m]
semicorsa1=0.093;                                         %% semicorsa lato camera a pressione P_A [m]
semicorsa2=0.093;                                         %% semicorsa lato camera a pressione P_B [m]
A_1=pi*(d_stantuffo^2-d_stelo^2)/4;                       %% superficie stantuffo camera di spinta [m^2]
A_2=pi*(d_stantuffo^2-d_stelo^2)/4;                       %% superficie stantuffo [m^2]
V_1=A_1*semicorsa1;                                       %% volume iniziale camera uno [m^3]
V_2=A_2*semicorsa2;                                       %% volume iniziale camera due [m^3]
V_ds1=0*A_1;                                            %% volume di spazio morto camera uno [m^3]
V_ds2=V_ds1;                                              %% volume di spazio morto camera due [m^3]
x=0;
x_dot=0;


gioco_radiale=3.54e-06;                                       %% gioco radiale [m]
    
Cd_gioco=0.33;                                            %% coefficiente di efflusso [-]

F_stall=(p_S-p_T)*A_1;

%% foro di by-pass

d_BP=1.3e-3;             %% diametro orifizio [m]
A_BP=pi*d_BP^2/4;        %% sezione di passaggio [m^2]

Cd_BP=0.37;


%% Trasduttore

sigma_t=200*2*pi;            %% frequenza propria [rad/s]
zeta_t=0.7;                  %% smorzamento [-]
K_t=0.91;                     %% guadagno statico [-]

%% Lancio il modello

sim('OL.slx');

%%
close all

figure
tiledlayout(2,1);
nexttile
title('Carico Sperimentale e Simulato in [N]')
plot(time,Load,LineWidth=2)
hold on 
plot(time,FB_SIMULATO,LineWidth=2)
legend('Carico sperimentale','Carico simulato')
ylabel('Load [N]')
xlabel('t [s]')
nexttile
plot(time,Spool_Cmd,LineWidth=2)
legend('V_{Set} [V]')
ylabel('[V]')
xlabel('t [s]')

figure
tiledlayout(2,1);
nexttile
title('Spostamento del cassetto sperimentale e simulato in [m]')
plot(time,Spool_FB*0.74/10)
ylabel('[mm]')
xlabel('t [s]')
hold on 
plot(time,(FB+2*bias)*0.74/10,LineWidth=2)
legend('Spostamento cassetto sperimentale','Spostamento cassetto simulato')
nexttile
plot(time,Spool_Cmd,LineWidth=2)
hold on
plot(time,Spool_FB)
legend('V_{Set} [V]','V_{Fb} [V]')
ylabel('[V]')
xlabel('t [s]')
